#ifndef BIPARTITEGRAPH_HPP
#define BIPARTITEGRAPH_HPP

#include <vector>
#include <unordered_set>
#include <utility>

class BipartiteGraph {
private:
    int n;                                        
    int maxMatching;                             
    std::vector<int> match;                        
    std::vector<int> inv_match;
    std::vector<std::vector<int>> BP;

    bool augmentingPath(int u, std::vector<bool>& visited);

public:
    BipartiteGraph(int numNodes);
    std::vector<std::vector<int>> convertDAGtoBP(const std::vector<std::vector<int>>& DAG, const std::vector<std::pair<int, int>>& edges);
    int Match();
    const std::vector<int>& getMatch() const;
    const std::vector<int>& getInvMatch() const;
    int getMaxMatching() const;
};

#endif

